
package w83b.w83bUtilidadesComunes;

import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

import w83b.xml.W83bXmlSchemaValidation;



public class W83bLazyLocaleString extends W83bLocaleString implements Serializable {
    /**
	 * Comment for <code>serialVersionUID</code>
	 */
	private static final long serialVersionUID = 1L;

	private String lazyLocale;
    
    private static final XMLReader reader = W83bXmlSchemaValidation.makeXMLReader();
    private static final W83bLazyLocaleString.W83bLocaleStringHandler handler = new W83bLazyLocaleString.W83bLocaleStringHandler();

    public W83bLazyLocaleString (String lazyLocale) {
        this.lazyLocale = lazyLocale;
    }
    
    public String getLazyLocale () {
        return lazyLocale;
    }
    
    public Enumeration getAllLocales() {
        if (this.string == null){
            createLocale();
        }
        return super.getAllLocales();
    }
    public String getString(Locale locale) {
        if (this.string == null){
            createLocale();
        }
        return super.getString(locale);
    }
    
    private void createLocale() {
        try {
            if (lazyLocale!=null && lazyLocale.length() > 0) {
	        	handler.resetLocaleString();
	            reader.setContentHandler(handler);
	            
	            InputSource is = new InputSource (new StringReader (lazyLocale));
	            reader.parse(is);
	            
	            string = handler.getLocaleString();
            } else {
                string = new Hashtable();
            }
        } catch (Exception e) {
            string = new Hashtable();
        }
    }

    public static class W83bLocaleStringHandler extends DefaultHandler {
    	private static final String ATT_LANGUAGE = "locale";
    
        private Hashtable textos= new Hashtable();
        private String language;
        private StringBuffer strTmp = new StringBuffer();
        
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (atts!=null && atts.getQName(0) != null && atts.getQName(0).equals(ATT_LANGUAGE)) {
                language = atts.getValue(0);
                strTmp.setLength(0);
            } else{
                language = null;
            }
        }
        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            if (language != null){
                textos.put (W83bLocaleStringXML.getLocale(language), strTmp.toString());
            }
        }
    	public void characters(char[] ch, int start, int length) throws SAXException {
            if (language != null){
                strTmp.append(ch, start, length);
            }
        }
        
    	public void resetLocaleString() {
    		textos = new Hashtable();
    	}
        public Hashtable getLocaleString () {
            return textos;
        }
    }

}
